################
# DEPENDENCIES #
################
FROM node:18-alpine AS deps
RUN apk add --no-cache libc6-compat
USER node
WORKDIR /app
COPY --chown=node:node package*.json ./
RUN npm ci

###########
# BUILDER #
###########
FROM node:18-alpine AS builder

USER node
WORKDIR /app

COPY --chown=node:node --from=deps /app/node_modules ./node_modules
COPY --chown=node:node . .

ENV NODE_ENV production
ENV NEXT_PUBLIC_URL APP_NEXT_PUBLIC_URL
ENV NEXT_PUBLIC_UPLOADS_URL APP_NEXT_PUBLIC_UPLOADS_URL
RUN npm run build

RUN npm ci --omit=dev && npm cache clean --force

##############
# PRODUCTION #
##############
FROM node:18-alpine AS runner

USER node
WORKDIR /app

ENV NODE_ENV production

COPY --chown=node:node --from=builder /app/node_modules ./node_modules
COPY --chown=node:node --from=builder /app/package*.json ./
COPY --chown=node:node --from=builder /app/entrypoint.sh ./

COPY --chown=node:node --from=builder /app/next.config.js ./
COPY --chown=node:node --from=builder /app/public ./public
COPY --chown=node:node --from=builder /app/.next ./.next

EXPOSE 3000

ENTRYPOINT ["/app/entrypoint.sh"]
CMD ["node_modules/.bin/next", "start"]

######################
# /app/entrypoint.sh #
######################

#!/bin/sh
set -Ex

function apply_path {
  test -n "$NEXT_PUBLIC_URL"
  test -n "$NEXT_PUBLIC_UPLOADS_URL"

  find /app/.next \( -type d -name .git -prune \) -o -type f -print0 | xargs -0 sed -i "s#APP_NEXT_PUBLIC_URL#$NEXT_PUBLIC_URL#g"
  find /app/.next \( -type d -name .git -prune \) -o -type f -print0 | xargs -0 sed -i "s#APP_NEXT_PUBLIC_UPLOADS_URL#$NEXT_PUBLIC_UPLOADS_URL#g"
}

apply_path
exec "$@"
