  function mesh (params) {
    const dims = params.dims
    const vertices = []
    const indices = []
    const normals = []

    for (let backFace = true, b = false; b !== backFace; backFace = backFace && b, b = !b) {
      // Sweep over 3-axes
      for (let d = 0; d < 3; ++d) {
        let i, j, k, l, w, h, side
        const u = (d + 1) % 3
        const v = (d + 2) % 3
        const x = [0, 0, 0]
        const q = [0, 0, 0]

        // Here we're keeping track of the side that we're meshing.
        if (d === 0) side = backFace ? LEFT : RIGHT
        else if (d === 1) side = backFace ? BOTTOM : TOP
        else if (d === 2) side = backFace ? BACK : FRONT

        const mask = new Int32Array(dims[u] * dims[v])
        q[d] = 1
        // Move through the dimension from front to back
        for (x[d] = -1; x[d] < dims[d];) {
          // Compute mask
          let n = 0
          for (x[v] = 0; x[v] < dims[v]; ++x[v]) {
            for (x[u] = 0; x[u] < dims[u]; ++x[u]) {
              const current = this.getBlockAt(params, dims, x[0], x[1], x[2])
              const ajacent = this.getBlockAt(params, dims, x[0] + q[0], x[1] + q[1], x[2] + q[2])
              mask[n++] = ((current && ajacent && current === ajacent)) ? null : (backFace ? ajacent : current)
            }
          }

          // Increment x[d]
          ++x[d]

          // Generate mesh for mask using lexicographic ordering
          n = 0
          for (j = 0; j < dims[v]; ++j) {
            for (i = 0; i < dims[u];) {
              if (mask[n]) {
                // Compute width
                for (w = 1; mask[n + w] && mask[n + w] === mask[n] && i + w < dims[u]; ++w) {}

                // Compute height
                let done = false
                for (h = 1; j + h < dims[v]; ++h) {
                  for (k = 0; k < w; ++k) {
                    if (!mask[n + k + h * dims[u]] || mask[n + k + h * dims[u]] !== mask[n]) {
                      done = true
                      break
                    }
                  }
                  if (done) break
                }

                // Create quad
                x[u] = i
                x[v] = j

                const du = [0, 0, 0]
                du[u] = w

                const dv = [0, 0, 0]
                dv[v] = h

                const quad = [
                  [x[0], x[1], x[2]],
                  [x[0] + du[0], x[1] + du[1], x[2] + du[2]],
                  [x[0] + du[0] + dv[0], x[1] + du[1] + dv[1], x[2] + du[2] + dv[2]],
                  [x[0] + dv[0], x[1] + dv[1], x[2] + dv[2]]
                ]

                // Add vertices and normals
                const mul = backFace ? -1 : 1
                for (var qindex = 0; qindex < 4; ++qindex) {
                  vertices.push(quad[qindex][0], quad[qindex][1], quad[qindex][2])
                  normals.push(q[0] * mul, q[1] * mul, q[2] * mul)
                }

                // Add indices
                const indexi = vertices.length / 3 - 4
                if (backFace) {
                  indices.push(indexi + 2, indexi + 1, indexi)
                  indices.push(indexi + 3, indexi + 2, indexi)
                } else {
                  indices.push(indexi, indexi + 1, indexi + 2)
                  indices.push(indexi, indexi + 2, indexi + 3)
                }

                // Zero-out mask
                for (l = 0; l < h; ++l) {
                  for (k = 0; k < w; ++k) {
                    mask[n + k + l * dims[u]] = false
                  }
                }

                // Increment counters and continue
                i += w
                n += w
              } else {
                ++i
                ++n
              }
            }
          }
        }
      }
    }

    return { vertices, indices, normals }
  }
}