// Get angle on circle from mouse position
function getAngleOnCircleFromOffsetMouse(evt) {
    const x = (evt.pageX - element.offset().left);
    const y = (evt.pageY - element.offset().top);

    // https://math.stackexchange.com/a/127615
    const center = { x: width / 2, y: width / 2 };
    const xCenter = (x - center.x);
    const yCenter = (y - center.y);
    const circlePoint = {
        x: center.x + radius * (xCenter / Math.sqrt(xCenter * xCenter + yCenter * yCenter)),
        y: center.y + radius * (yCenter / Math.sqrt(xCenter * xCenter + yCenter * yCenter)),
    };

    const angle = Math.atan2(circlePoint.y - center.y, circlePoint.x - center.x) + Math.PI / 2;
    return angle < 0 ? Math.PI * 2 - Math.abs(angle) : angle;
}