function getSectorPath(centre, rIn, rOut, startDeg, delta) {
    const startOut = {
        x: centre.x + rOut * Math.cos(startDeg),
        y: centre.y + rOut * Math.sin(startDeg)
    };
    const endOut = {
        x: centre.x + rOut * Math.cos(startDeg + delta),
        y: centre.y + rOut * Math.sin(startDeg + delta)
    };
    const startIn = {
        x: centre.x + rIn * Math.cos(startDeg + delta),
        y: centre.y + rIn * Math.sin(startDeg + delta)
    };
    const endIn = {
        x: centre.x + rIn * Math.cos(startDeg),
        y: centre.y + rIn * Math.sin(startDeg)
    };
    const largeArc = delta > 180 ? 1 : 0;

    return [
        `M${startOut.x},${startOut.y}`, `A${rOut},${rOut}`, '0',
        `${largeArc},1`, `${endOut.x},${endOut.y}`,
        `L${startIn.x},${startIn.y}`,
        `A${rIn},${rIn}`, '0', `${largeArc},0`,
        `${endIn.x},${endIn.y}`,
        `L${startOut.x},${startOut.y}`, 'Z',
    ].join(' ');
}